# Software platform for CP411 Computer Graphics 

Author: HBF
Date: 2025-06-03

## What's about?

This package contains software and libraries for CP411 Computer Graphics programming and course work environment. It runs on Windows 10/11 with Intel/AMD/NVIDIA graphics card.

Software systems: 

1. mingw GNU C/C++ 64bit compiler, and compatible OpenGL libraries (included)
2. Test examples of OpenGL and GLSL
3. Pandoc, a document format convert program, will be used to convert markdown to html for assignment reports.

Folders:

cp411 : the root folder of the CP411 software platform 
  - mingw64  : contains MinGW C/C++ 64bit compiler, and OpenGL libraries.
  - usr  : a minimal system for Unix like command shell on Windows console, based on POSIX command shells (such as bash). It allows you to run shell scripts that will then run the MinGW gcc compiler and other tools e.g. make, to build applications.  
  - examples  : contains two Eclipse projects of graphics examples.
  - Pandoc : contains pandoc.exe to convert markdown format to other document formats
  - assignments : contains assignment folders of a1, ..., a6

## How to install

You can simply extract this package to the C drive under C: directory (or an alternative directory). Then mingw64 will be in directory  C:\cp411\mingw64, and so on. 

### Configure GNU C/C++ compiler

1. Add `C:\cp411\mingw64\bin` to user's environment Path variable.
2. Add `C:\cp411\usr\bin` to user's environment Path variable.
3. Add `C:\cp411\pandoc` to user's environment Path variable.

Click OKs to close the environment varable panels. Open a command line console (cmd), type and run command:

```bash
gcc --version
```
The output is like the following.

gcc (Rev5, Built by MSYS2 project) 15.1.0
Copyright (C) 2025 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

Note that if you have other version of mingw installed on your computer, remove their environment Path variable. 

Use the following commands to verify gcc.exe, g++.exe, pandoc.exe, and make.exe programs are in the proper directories. 
 
```bash
where gcc g++  pandoc make
```

The output is like: 

```
C:\cp411\mingw64\bin\gcc.exe
C:\cp411\mingw64\bin\g++.exe
C:\cp411\pandoc\pandoc.exe
C:\cp411\usr\bin\make.exe
```

### Test C++ compiler

1. Open a cmd terminal, cd to directory `C:\cp411\examples\opengl_test`, use the following command to build myopengl.cpp program. 

```bash
g++ myopengl.cpp -o myopengl.exe -lglu32 -lopengl32 -lfreeglut
```

Run the resulted executable myopengl.exe by clicking it by command: `myopengl.exe`.  Check the opengl_test/README.md for details.


2. Test GLSL support. 

In the cmd terminal, cd to `C:\cp411\examples\glsl_demo`, use the following command to open VS code to the folder, assumming that VS code is installed on your machine. 

```bash
code .
```

Read the project README file and follow instructions to build, run the glsl_demo program. 



