# Warp up C++ by examples

Author: HBF

date: 2021-06-06

About: Quick start on C++ by examples. 

Prerequisite: knowledge and skill on C. 

## What it contains

C++ (or CPP) is a primary OPP programming language. It is an extension of C with additional OOP features. The following examples demonstrates the OPP features of C++. 

- [hello.cpp](hello.cpp)   : hello world example
- [format_output.cpp](format_output.cpp)  : output format
- [datatype.cpp](datatype.cpp ) :  data types
- [struct_record.cpp](struct_record.cpp) :  structure in C++ 
- [string.cpp](string.cpp) :  string object
- [dynamic.cpp](dynamic.cpp) :  dynamic memory allocation/deallocation using new/delete
- [input.cpp](input.cpp) :  input from keyboard
- [fileio.cpp](fileio.cpp)  :  file i/o
- [function.cpp](function.cpp) : function syntax in C++ 
- [class1.cpp](class1.cpp) :  class syntax
- [class2.cpp](class2.cpp) :  inheritance
- [class3.cpp](class3.cpp) :  polymorphism, abstract
- [class4.cpp](class4.cpp) :  class type casting
- [class5.cpp](class5.cpp) :  exception and user defined exception class
- [namespace.cpp](namespace.cpp) :  use namespace to organize names variables and functions.  
- [Rectangle.hpp](Rectangle.hpp) :  use header to define class template
- [Rectangle.cpp](Rectangle.cpp) :  implementation of class header
- [Rectangle_main.cpp](Rectangle_main.cpp) : use class object in driver program


## How to run

It needs a C++ compiler, e.g. GNU C++ compiler, or MinGW for Windows. We assume Windows OS the following.  

1. Download [warm_up_cpp.zip](warm_up_cpp.zip) and unzip to a directory, say C:/cpp 
2. Open cmd console, cd to the above directory. 
3. For each program file, open, read, understand, compile, and run.
4. You can also run Windows batch test.bat,  which compiles and runs all the programs. 
5. Run clean.bat to deletes all generated executable files.

## References

1. [C++ tutorial at W3School](https://www.w3schools.com/java/default.asp)
